const defaultConfig = require('@wordpress/scripts/config/webpack.config');
const CopyWebpackPlugin = require('copy-webpack-plugin');
const CssMinimizerPlugin = require('css-minimizer-webpack-plugin');
const path = require('path');

module.exports = {
	...defaultConfig,
    
	plugins: [
		...defaultConfig.plugins,
		new CopyWebpackPlugin({
			patterns: [
				{
					from: 'blocks/**/preview.webp',
					to: ({ context, absoluteFilename }) => {
						const relativeBlockPath = path.relative(
							path.resolve(__dirname, 'blocks'),
							path.dirname(absoluteFilename)
						);
						return path.resolve(__dirname, `build/blocks/${relativeBlockPath}/preview.webp`);
					},
				},
			],
		}),
	],

	resolve: {
		...defaultConfig.resolve,
		alias: {
			...defaultConfig.resolve.alias,
			'@blocks': path.resolve(__dirname, 'blocks'),
			'@scss': path.resolve(__dirname, 'resources/scss'),
			'@js': path.resolve(__dirname, 'resources/js'),
			'@fonts': path.resolve(__dirname, 'resources/fonts'),
			'@images': path.resolve(__dirname, 'resources/images'),
		},
	},

	optimization: {
		...defaultConfig.optimization,
		minimizer: [
			...(defaultConfig.optimization?.minimizer || []),
			new CssMinimizerPlugin(),
		],
	},
};
