<?php

use Headless\Utils\CommonUtils;

$id             = get_field('form_block_id',    'option');
$header_icon    = get_field('form_header_icon', 'option');
$block_title    = get_field('form_title',       'option');
$block_text     = get_field('form_text',        'option');
$contact_list   = get_field('contact_list',     'option');

?>

<section class="contact-from" <?php if (!empty($id)) echo "id='{$id}'"; ?>>
    <div class="container">
        <?php if(!empty($block_title)): ?>
            <div class="section-header d-flex">
                <?= CommonUtils::render_image_acf($header_icon, [ 'width' => 24, 'height' => 24, 'alt' => 'Section icon', 'class' => 'about__icon' ]); ?>
                <?=$block_title?>
            </div>
        <?php endif; ?>

        <?php if(!empty($block_text)): ?>
            <div class="contact-from__title"><?=$block_text?></div>
        <?php endif; ?>

        <div class="contact-from__content d-grid">
            <?php if($contact_list && is_array($contact_list)): ?>
                <?php foreach ($contact_list as $info): ?>
                    <div class="contact-from__item">
                        <?php if(isset($info['address']) && !empty($info['address'])): ?>
                            <p class="contact-from__address"><?=$info['address']?></p>
                        <?php endif; ?>
                        <?php if(isset($info['email']) && !empty($info['email'])): ?>
                            <p class="contact-from__email">
                                <img src="<?=RESOURCES_URL?>/main/imgs/footer/mail.svg" alt="mail icon" width="20" height="20" /> <?=__('Email', 'baltum')?>: <a href="mailto:<?=$info['email']?>" target="_blank"><?=$info['email']?></a>
                            </p>
                        <?php endif; ?>
                        <?php if(isset($info['phone_number']) && !empty($info['phone_number'])): ?>
                            <p class="contact-from__phone">
                                <img src="<?=RESOURCES_URL?>/main/imgs/footer/telephone.svg" alt="telephone icon" width="20" height="20" /> <?=__('Phone number', 'baltum')?>: <a href="tel:<?=$info['phone_number']?>" target="_blank"><?=$info['phone_number']?></a>
                            </p>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>

            <?php get_template_part('tmp/form-main'); ?>

        </div>
    </div>
</section>