<?php 

get_header(); 

$translations	= get_field( 'translations', 	'option')  ?: [];

if(!isset($translations['minutes']) || empty($translations['minutes'])) $translations['minutes'] = 'min';
if(!isset($translations['on_this_page']) || empty($translations['on_this_page'])) $translations['loading'] = 'On this page';
if(!isset($translations['reading_time']) || empty($translations['reading_time'])) $translations['reading_time'] = 'Reading time';

?>

<main id="main" class="site-main blog-article">
	<?php
	if (have_posts()) {
		while (have_posts()) {
			the_post();
			$tags         = get_the_terms(get_the_ID(), 'post_tag');
			$word_count   = str_word_count(wp_strip_all_tags(get_post_field('post_content', get_the_ID())));
			$reading_time = max(1, (int) ceil($word_count / 200));
	?>
			<div class="container js-entryContent">
				<a href="/blog/" class="blog-article__back">Back</a>
				<h1><?php the_title(); ?></h1>
				<div class="blog-article__cols d-flex flex-column-reverse flex-lg-row">
					<div class="blog-article__content"><?php the_content(); ?></div>
					<div class="blog-article__info">
						<div class="blog-article__sidebar">							
							<div class="blog-article__tags d-flex flex-wrap">
								<?php if ($tags && ! is_wp_error($tags)) : ?>
									<?php foreach ($tags as $tag) : ?>
										<span class="blog-article__tag"><?= esc_html($tag->name); ?></span>
									<?php endforeach; ?>
								<?php endif; ?>
							</div>
							<time class="d-block" datetime="<?= esc_attr(get_the_date('c')); ?>"><?= esc_html(get_the_date('F j, Y')); ?></time>
							<div class="blog-article__reading-time">
								<p class="blog-article__reading-time__title"><?= $translations['reading_time'] ?></p>
								<div class="blog-article__reading-time__data">
									<span aria-hidden="true" class="d-inline-block">
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
											<path d="M10.0013 5V10L13.3346 11.6667M18.3346 10C18.3346 14.6024 14.6037 18.3333 10.0013 18.3333C5.39893 18.3333 1.66797 14.6024 1.66797 10C1.66797 5.39762 5.39893 1.66666 10.0013 1.66666C14.6037 1.66666 18.3346 5.39762 18.3346 10Z" stroke="#131314" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
										</svg>
									</span><?= esc_html($reading_time); ?> <?= $translations['minutes'] ?>
								</div>
							</div>
							<div class="blog-article__on-this-page">
								<p class="blog-article__on-this-page__title"><?= $translations['on_this_page'] ?></p>
								<div class="blog-article__on-this-page__list js-onThisPage"></div>
							</div>
						</div>
					</div>
				</div>
			</div>
	<?php }
	} ?>
</main>
<?php
get_template_part('tmp/contact-from');
get_footer();
