import domReady from '@wordpress/dom-ready';
import './styles.scss';

domReady(() => {
    // Helper function to set sidebar width
    function setSidebarWidth() {
        const sidebar = document.querySelector('.interface-interface-skeleton__sidebar');
        if (!sidebar) return;

        const savedWidth = localStorage.getItem('toast_rs_personal_sidebar_width');
        if (savedWidth) {
            sidebar.style.width = `${savedWidth}px`;
        }
    }

    // Helper function to make element resizable
    function makeResizable(element) {
        let startX, startWidth;

        const resizer = document.createElement('div');
        resizer.style.width = '5px';
        resizer.style.height = '100%';
        resizer.style.position = 'absolute';
        resizer.style.left = '0';
        resizer.style.top = '0';
        resizer.style.cursor = 'ew-resize';
        element.style.position = 'relative';
        element.appendChild(resizer);

        function startResize(e) {
            startX = e.clientX;
            startWidth = parseInt(getComputedStyle(element).width, 10);
            document.addEventListener('mousemove', resize);
            document.addEventListener('mouseup', stopResize);
            e.preventDefault();
        }

        function resize(e) {
            const width = startWidth - (e.clientX - startX);
            element.style.width = `${width}px`;
            element.style.left = '0';
            localStorage.setItem('toast_rs_personal_sidebar_width', width);
        }

        function stopResize() {
            document.removeEventListener('mousemove', resize);
            document.removeEventListener('mouseup', stopResize);
        }

        resizer.addEventListener('mousedown', startResize);
    }

    // Function to determine if sidebar is open
    function determineIfSidebarOpen() {
        const pinnedButtons = document.querySelectorAll('.interface-pinned-items button');
        const sidebarEnabled = Array.from(pinnedButtons).some(button =>
            button.classList.contains('is-pressed')
        );

        const layouts = document.querySelectorAll('.edit-post-layout, .edit-site-layout');
        layouts.forEach(layout => {
            if (sidebarEnabled) {
                layout.classList.add('is-sidebar-opened');
            } else {
                layout.classList.remove('is-sidebar-opened');
            }
        });
    }

    // Set up interval for continuous checks
    setInterval(() => {
        const sidebar = document.querySelector('.interface-interface-skeleton__sidebar');
        if (sidebar) {
            setSidebarWidth();
            makeResizable(sidebar);
        }
        determineIfSidebarOpen();
    }, 500);

    // Event delegation for pinned items clicks
    document.body.addEventListener('click', function (e) {
        if (e.target.closest('.interface-pinned-items button')) {
            determineIfSidebarOpen();
        }
    });

});