// STYLES
import './main/scss/app.scss';
import './main/scss/blog.scss';
import './../blocks/contact-from/contact-from.scss';

// JS
import './main/js/nav';
import './main/js/SmoothScroll';
import './main/js/popup';

jQuery(function ($) {
	/**
	 * Load more posts on archive page.
	 */
	const $btn = $('.js-blog-loadmore');
	const $list = $('.js-blog-list');

	if ($btn.length && $list.length) {
		const cfgAttr = $btn.attr('data-loadmore');
		let cfg;

		try {
			cfg = cfgAttr ? JSON.parse(cfgAttr) : null;
		} catch (e) {
			cfg = null;
		}

		if (cfg && cfg.ajaxUrl && cfg.nonce) {
			let page = parseInt(cfg.currentPage || 1, 10);
			const maxPage = parseInt(cfg.maxPage || 1, 10);
			const labels = {
				more: (cfg.labels && cfg.labels.more) ? cfg.labels.more : ($btn.text() || 'Load more'),
				loading: (cfg.labels && cfg.labels.loading) ? cfg.labels.loading : 'Loading...'
			};

			if (page >= maxPage) {
				$btn.remove();
				return;
			}

			const setLoading = (state) => {
				if (state) {
					$btn.addClass('is-loading').prop('disabled', true).text(labels.loading);
				} else {
					$btn.removeClass('is-loading').prop('disabled', false).text(labels.more);
				}
			};

			$btn.on('click', function (e) {
				e.preventDefault();
				if ($btn.hasClass('is-loading') || page >= maxPage) {
					return;
				}

				setLoading(true);

				$.post(cfg.ajaxUrl, {
					action: 'headless_load_more_posts',
					nonce: cfg.nonce,
					page: page + 1,
					queryVars: cfg.queryVars || {}
				}).done((resp) => {
					if (resp && resp.success && resp.data && resp.data.html) {
						$list.append(resp.data.html);
						page += 1;

						if (page >= maxPage) {
							$btn.remove();
						}
					}
				}).fail(() => {
					// no-op; could log if needed
				}).always(() => {
					if ($btn.length) {
						setLoading(false);
					}
				});
			});
		}
	}
});
