<?php

declare( strict_types=1 );

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Configuration file for the Headless theme
 *
 * Defines the list of modules to be loaded by the bootstrap process. Each module
 * must implement the Registrable interface and use the Loadable trait to register
 * itself with Core
 *
 * To add a new module, append its fully qualified class name to the 'modules' array.
 * To disable a module, simply remove it from this list without deleting its file
 *
 */
return [
	// List of modules to be bootstrapped
	'modules'   => [
		// Core functionality modules
		'Headless\Modules\Assets\AssetsManager', 					// Theme assets (CSS, JS)
		'Headless\Modules\Blocks\BlocksManager', 					// Custom blocks
		'Headless\Modules\Entities\EntitiesManager', 				// Custom Post Types and taxonomies
		'Headless\Modules\Patterns\PatternsManager', 				// Patterns
		'Headless\Modules\Menu\MenuWalker', 						// Menu walker
		'Headless\Modules\Menu\FooterMenuWalker', 					// Menu walker

		// Integration modules
		// 'Headless\Modules\GraphQL\Blocks\GraphQLBlocksManager', // GraphQL enhancements for blocks
	],
	// Theme constants
	'constants' => [
		'ENV'        => getenv( 'ENV' ) ?: 'dev', // Development or production
		'BUILD_PATH' => get_template_directory() . '/build/', // Absolute path to the build directory
		'BUILD_URL'  => get_template_directory_uri() . '/build/', // URL to the build directory
		'APP_DIR'    => get_template_directory() . '/app/', // Absolute path to the app directory
	],
];