<?php

use Headless\Utils\CommonUtils;

$id               = get_field('block_id');
$header_icon      = get_field('header_icon');
$block_title      = get_field('title');
$block_text       = get_field('text');
$block_text_small = get_field('text_small');
$team_members     = get_field('team_members');
?>

<section class="team" <?php if (!empty($id)) echo "id='{$id}'"; ?>>
    <div class="container">
        <?php if(!empty($block_title)): ?>
            <div class="section-header d-flex">
                <?= CommonUtils::render_image_acf($header_icon, [ 'width' => 24, 'height' => 24, 'alt' => 'Section icon', 'class' => 'about__icon' ]); ?>
                <?=$block_title?>
            </div>
        <?php endif; ?>
        <div class="team__content">

            <?php if(!empty($block_text) || !empty($block_text_small)): ?>
                <div class="team__text">
                    <?php if(!empty($block_text)): ?>
                        <div class="team__text__big"><?=$block_text?></div>
                    <?php endif; ?>

                    <?php if(!empty($block_text_small)): ?>
                        <div class="team__text__small"><?=$block_text_small?></div>
                    <?php endif; ?>
                    
                </div>
            <?php endif; ?>
            
            <?php if(!empty($team_members) && is_array($team_members)): ?>
                <div class="team__members">
                    <?php foreach ($team_members as $team_member): ?>
                        <div class="team__members__item">

                            <?php 
                                if(isset($team_member['photo'])){
                                    echo CommonUtils::render_image_acf(
                                        $team_member['photo'],
                                        ['width' => 303, 'height' => 310, 'alt' => 'Photo', 'class' => 'team__members__item__photo']
                                    );
                                } 
                            ?>

                            <?php if(!empty($team_member['name'])): ?>
                                <p class="team__members__item__name heading-3"><?=$team_member['name']?></p>
                            <?php endif; ?>
                            
                            <?php if(!empty($team_member['job_position'])): ?>
                                <p class="team__members__item__job-position heading-3"><?=$team_member['job_position']?></p>
                            <?php endif; ?>
                            
                            <?php if(!empty($team_member['text'])): ?>
                                <p class="team__members__item__text"><?=$team_member['text']?></p>
                            <?php endif; ?>

                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

        </div>

    </div>
</section>
