<?php
    use Headless\Utils\CommonUtils;

    $block_title    = get_field('hero_title');
    $block_text     = get_field('hero_text');
    $block_link     = get_field('button');
    $id             = get_field('block_id');
?>

<section class="homepage-hero" <?php if (!empty($id)) echo "id='{$id}'"; ?>>
    <div class="container">
        
        <?php if (!empty($block_title)) : ?>
            <h1 tabindex="0"><?= esc_html($block_title); ?></h1>
        <?php endif; ?>

        <div tabindex="0" class="homepage-hero__text">
            <?php if (!empty($block_text)) : ?>
                <?= $block_text ?>
            <?php endif; ?>
            <?php if (!empty($block_link)) : $block_link['classes'] = ['btn']; ?>
                <?= CommonUtils::render_link( $block_link ) ?>
            <?php endif; ?>
        </div>

    </div>
</section>