<?php

use Headless\Utils\CommonUtils;

$id             = get_field('block_id');
$header_icon    = get_field('header_icon');
$block_title    = get_field('title');
$text           = get_field('text');
$cards          = get_field('cards');
$block_link     = get_field('button');
?>

<section class="benefits-certification" <?php if (!empty($id)) echo "id='{$id}'"; ?>>
    <div class="container">
        <?php if(!empty($block_title)): ?>
            <div class="section-header d-flex">
                <?= CommonUtils::render_image_acf($header_icon, [ 'width' => 24, 'height' => 24, 'alt' => 'header block icon', 'class' => 'benefits-certification__icon' ]); ?>
                <?=$block_title?>
            </div>
        <?php endif; ?>
    </div>

    <div class="container benefits-certification__content">

        <div class="benefits-certification__text"><?php if(!empty($text)) echo $text; ?></div>

        <?php if(!empty($cards) && is_array($cards)): ?>
            <div class="benefits-certification__cards">
                <?php foreach($cards as $card): ?>
                    <div class="benefits-certification__cards__item d-flex flex-column">
                        <?php if(isset($card['icon'])){
                            echo CommonUtils::render_image_acf($card['icon'], [ 'width' => 25, 'height' => 25, 'alt' => 'Card icon', 'class' => 'benefits-certification__cards__icon' ]);
                        } ?>
                        <?php if(isset($card['title'])): ?>
                            <p class="benefits-certification__cards__title"><?=$card['title']?></p>
                        <?php endif; ?>
                        
                        <?php if(isset($card['text'])): ?>
                            <p class="benefits-certification__cards__text"><?=$card['text']?></p>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?> 

        <?php if (!empty($block_link)) : $block_link['classes'] = ['btn']; ?>
            <div class="benefits-certification__cta d-flex align-items-end">
                <?= CommonUtils::render_link( $block_link ) ?>
            </div>
        <?php endif; ?>

    </div>
</section>
