<?php

use Headless\Utils\CommonUtils;

$id             = get_field('block_id');
$header_icon    = get_field('header_icon');
$block_title    = get_field('title');
$block_text     = get_field('text');
$cards          = get_field('cards');
$image          = get_field('image');
$block_link     = get_field('button');
?>

<section class="about" <?php if (!empty($id)) echo "id='{$id}'"; ?>>
    <div class="container">
        <div class="about__grid">
            <div class="about__info">
                <?php if(!empty($block_title)): ?>
                    <div class="section-header d-flex">
                        <?= CommonUtils::render_image_acf($header_icon, [ 'width' => 24, 'height' => 24, 'alt' => 'Section icon', 'class' => 'about__icon' ]); ?>
                        <?=$block_title?>
                    </div>
                <?php endif; ?>

                <?php if(!empty($block_text)): ?>
                    <div class="about__text"><?=$block_text?></div>
                <?php endif; ?>
            </div>

            <?php if(!empty($cards) && is_array($cards)): ?>
                <div class="about__cards">
                    <?php foreach($cards as $card):
                        if(isset($card['text']) && !empty($card['text'])): ?>
                            <div class="about-card">
                                <div class="about-card__text"><?=$card['text']?></div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <?php if(!empty($image)): ?>
                <div class="about__image">
                    <?= CommonUtils::render_image_acf($image, [ 'width' => 690, 'height' => 789, 'alt' => 'About image' ]); ?>
                </div>
            <?php endif; ?>

            <?php if (!empty($block_link)) : $block_link['classes'] = ['btn']; ?>
                <div class="about__cta">
                    <?= CommonUtils::render_link( $block_link ) ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>
