<?php

use Headless\Utils\CommonUtils;

$id             = get_field('block_id');
$header_icon    = get_field('header_icon');
$block_title    = get_field('title');
$image          = get_field('image');
$cards          = get_field('cards');
$block_link     = get_field('button');

$list_count    = is_array($cards) ? count($cards) : 0;

?>

<section class="why-us" <?php if (!empty($id)) echo "id='{$id}'"; ?>>
    <div class="container">
        <?php if(!empty($block_title)): ?>
            <div class="section-header d-flex">
                <?= CommonUtils::render_image_acf($header_icon, [ 'width' => 24, 'height' => 24, 'alt' => 'Section icon', 'class' => 'why-us__icon' ]); ?>
                <?=$block_title?>
            </div>
        <?php endif; ?>
    </div>

    <div class="container">
        <div class="why-us__content">

            <?php if(isset($image)){ ?>
                <div class="why-us__image" style="order: 0;">
                    <?=CommonUtils::render_image_acf($image, [ 'width' => 451, 'height' => 301, 'alt' => 'Card icon' ])?>
                </div>            
            <?php } ?>

            <?php if(!empty($cards) && is_array($cards)): ?>
                <div class="why-us__cards">
                    <?php foreach($cards as $i => $card): if($list_count - 1 == $i) {$text_order = $i; $i++;} ?>
                        <div class="why-us__cards__item d-flex flex-column justify-content-end" style="order: <?=$i?>;">
                            <?php if(isset($card['icon'])){
                                echo CommonUtils::render_image_acf($card['icon'], [ 'width' => 25, 'height' => 25, 'alt' => 'Card icon', 'class' => 'why-us__cards__icon' ]);
                            } ?>
                            <?php if(isset($card['title'])): ?>
                                <p class="why-us__cards__title"><?=$card['title']?></p>
                            <?php endif; ?>
                            
                            <?php if(isset($card['text'])): ?>
                                <p class="why-us__cards__text"><?=$card['text']?></p>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?> 

            <?php if (!empty($block_link)) : $block_link['classes'] = ['btn', 'btn-white']; ?>
                <div class="why-us__cta d-flex align-items-end" style="order: <?=$list_count - 1?>">
                    <?= CommonUtils::render_link( $block_link ) ?>
                </div>
            <?php endif; ?>

        </div>
    </div>
</section>
