<?php

use Headless\Utils\CommonUtils;

$id             = get_field('block_id');
$header_icon    = get_field('header_icon');
$block_title    = get_field('title');
$tools_list     = get_field('tools_list');

?>

<section class="tools" <?php if (!empty($id)) echo "id='{$id}'"; ?>>
    <div class="container">
        <?php if(!empty($block_title)): ?>
            <div class="section-header d-flex">
                <?= CommonUtils::render_image_acf($header_icon, [ 'width' => 24, 'height' => 24, 'alt' => 'Section icon' ]); ?>
                <?=$block_title?>
            </div>
        <?php endif; ?>
    </div>

    <div class="container">
        <div class="tools__content d-grid">
            <?php if(!empty($tools_list) && is_array($tools_list)):
                    foreach($tools_list as $tool): ?>
                        <div class="tools__card d-flex align-content-center justify-content-center">
                            <?=CommonUtils::render_image_acf($tool, [ 'width' => 180, 'height' => 90, 'alt' => 'Tool logo' ]);?>
                        </div>
                <?php endforeach; ?>
            <?php endif; ?>            
        </div>
    </div>
</section>
