import metadata from "./block.json";
import './team.scss';
// Slick
import 'slick-carousel';
import 'slick-carousel/slick/slick.scss';

(function($) {
    const MOBILE_BREAKPOINT = 768;

    const initSlider = ($list) => {
        if (!$list.length || typeof $.fn.slick !== 'function') {
            if (typeof $.fn.slick !== 'function') {
                console.warn('Slick is not available for team block');
            }
            return;
        }

        if ($list.hasClass('slick-initialized')) return;

        $list.slick({
            arrows: false,
            dots: false,
            infinite: false,
            speed: 400,
            slidesToShow: 1.25,
            slidesToScroll: 1,
            swipeToSlide: true,
            adaptiveHeight: true,
            mobileFirst: true,
            autoplay: true,
            autoplaySpeed: 2000,
            responsive: [
                {
                    breakpoint: 576,
                    settings: {
                        slidesToShow: 2,
                    },
                }
            ],
        });
    };

    const destroySlider = ($list) => {
        if ($list.hasClass('slick-initialized')) {
            $list.slick('unslick');
        }
    };

    const handleToggle = ($context) => {
        const isMobile = window.innerWidth < MOBILE_BREAKPOINT;
        $context.find('.team__members').each(function() {
            const $list = $(this);
            if (isMobile) {
                initSlider($list);
            } else {
                destroySlider($list);
            }
        });
    };

    const bindResize = ($context) => {
        let resizeTimeout = null;
        $(window).off('resize.team orientationchange.team');
        $(window).on('resize.team orientationchange.team', () => {
            clearTimeout(resizeTimeout);
            resizeTimeout = setTimeout(() => handleToggle($context || $(document)), 150);
        });
    };

    const initBlock = ($root) => {
        const $context = ($root && $root.length) ? $root : $(document);
        handleToggle($context);
        bindResize($context);
    };

    if (window.acf) {
        acf.addAction('render_block_preview/type=' + metadata.name, initBlock);
    }

    $(function() {
        initBlock($(document));
    });
})(jQuery);