import metadata from "./block.json";
import './our-partners.scss';

// Slick
import 'slick-carousel';
import 'slick-carousel/slick/slick.scss';

(function($) {
    const MOBILE_BREAKPOINT = 768;

    const initSlider = ($list) => {
        if (!$list.length || typeof $.fn.slick !== 'function') {
            if (typeof $.fn.slick !== 'function') {
                console.warn('Slick is not available for team block');
            }
            return;
        }

        if ($list.hasClass('slick-initialized')) return;

        $list.slick({
            arrows: false,
            dots: false,
            infinite: false,
            speed: 400,
            slidesToShow: 1.25,
            slidesToScroll: 1,
            swipeToSlide: true,
            adaptiveHeight: true,
            mobileFirst: true,
            autoplay: true,
            autoplaySpeed: 2000,
            responsive: [
                {
                    breakpoint: 576,
                    settings: {
                        slidesToShow: 2.25,
                    },
                }
            ],
        });
    };

    const destroySlider = ($list) => {
        if ($list.hasClass('slick-initialized')) {
            $list.slick('unslick');
            const $ourPartnersItem = $('.js-ourPartnersItem');
            $ourPartnersItem.each(function(index) {
                if($ourPartnersItem.length - 1 == index) index++;
                $(this).attr("style", "order : " + index);
            })
        }
    };

    const handleToggle = ($context) => {
        const isMobile = window.innerWidth < MOBILE_BREAKPOINT;
        $context.find('.js-ourPartnersCards').each(function() {
            const $list = $(this);
            if (isMobile) {
                initSlider($list);
            } else {
                destroySlider($list);
            }
        });
    };

    const bindResize = ($context) => {
        let resizeTimeout = null;
        $(window).off('resize.our-partners orientationchange.our-partners');
        $(window).on('resize.our-partners orientationchange.our-partners', () => {
            clearTimeout(resizeTimeout);
            resizeTimeout = setTimeout(() => handleToggle($context || $(document)), 150);
        });
    };

    const initBlock = ($root) => {
        const $context = ($root && $root.length) ? $root : $(document);
        handleToggle($context);
        bindResize($context);
    };

    if (window.acf) {
        acf.addAction('render_block_preview/type=' + metadata.name, function(block) {
            initBlock(block.$el);
        });
    }

    $(function() {
        initBlock($(document));
    });
})(jQuery);