import metadata from "./block.json";
import './our-customers.scss';
// Slick
import 'slick-carousel';
import 'slick-carousel/slick/slick.scss';

(function($) {
    const MOBILE_BREAKPOINT = 768;

    const initSlider = ($list) => {
        if (!$list.length || typeof $.fn.slick !== 'function') {
            if (typeof $.fn.slick !== 'function') {
                console.warn('Slick is not available for team block');
            }
            return;
        }

        if ($list.hasClass('slick-initialized')) return;
        
        $list.slick({
            arrows: false,
            dots: false,
            infinite: true,
            speed: 400,
            slidesToShow: 1.5,
            slidesToScroll: 1,
            swipeToSlide: true,
            adaptiveHeight: true,
            mobileFirst: true,
            autoplay: true,
            autoplaySpeed: 2000,
            responsive: [
                {
                    breakpoint: 576,
                    settings: {
                        slidesToShow: 2.35,
                    },
                },
                {
                    breakpoint: 768,
                    settings: {
                        slidesToShow: 4,
                    },
                },
                {
                    breakpoint: 1250,
                    settings: {
                        slidesToShow: 5,
                    },
                }
            ],
        });
    };

    const handleToggle = ($context) => {
        const isMobile = window.innerWidth < MOBILE_BREAKPOINT;
        $context.find('.our-customers__list').each(function() {
            const $list = $(this);
            initSlider($list);
        });
    };

    const bindResize = ($context) => {
        let resizeTimeout = null;
        $(window).off('resize.our-customers orientationchange.our-customers');
        $(window).on('resize.our-customers orientationchange.our-customers', () => {
            clearTimeout(resizeTimeout);
            resizeTimeout = setTimeout(() => handleToggle($context || $(document)), 150);
        });
    };

    const initBlock = ($root) => {
        const $context = ($root && $root.length) ? $root : $(document);
        handleToggle($context);
        bindResize($context);
    };

    if (window.acf) {
        acf.addAction('render_block_preview/type=' + metadata.name, initBlock);
    }

    $(function() {
        initBlock($(document));
    });
})(jQuery);