<?php

use Headless\Utils\CommonUtils;

$id               = get_field('block_id');
$header_icon      = get_field('header_icon');
$block_title      = get_field('title');
$block_text       = get_field('text');
$steps            = get_field('steps');
?>

<section class="certification-process" <?php if (!empty($id)) echo "id='{$id}'"; ?>>
    <div class="container">

        <div class="certification-process__top">
            <?php if(!empty($block_title)): ?>
                <div class="section-header d-flex">
                    <?= CommonUtils::render_image_acf($header_icon, [ 'width' => 24, 'height' => 24, 'alt' => 'Section icon', 'class' => 'about__icon' ]); ?>
                    <?=$block_title?>
                </div>
            <?php endif; ?>
            
            <?php if(!empty($block_text)): ?>
                <div class="certification-process__text"><?=$block_text?></div>
            <?php endif; ?>
        </div>

        <?php if(!empty($steps) && is_array($steps)): ?>
            <div class="certification-process__steps">
                <?php foreach($steps as $step): ?>
                    <div class="certification-process__item d-flex flex-column">
                        <div class="certification-process__title">
                            <?php if(isset($step['number']) && !empty($step['number'])): ?>
                                <div class="certification-process__number"><?=$step['number']?></div>
                            <?php endif; ?>
                        </div>
                        <div class="certification-process__card d-flex flex-column">
                            <?php 
                                if(isset($step['icon']) && !empty($step['icon'])){
                                    echo CommonUtils::render_image_acf($step['icon'], [ 'width' => 24, 'height' => 24, 'alt' => 'Card icon', 'class' => 'certification-process__icon' ]);
                                }
                            ?>
                            <?php if(isset($step['title']) && !empty($step['title'])): ?>
                                <p class="certification-process__name"><?=$step['title']?></p>
                            <?php endif; ?>
                            <?php if(isset($step['text']) && !empty($step['text'])): ?>
                                <p class="certification-process__text"><?=$step['text']?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

    </div>
</section>
