<?php

use Headless\Utils\Block\BlogArticleUtils;
use Headless\Utils\CommonUtils;

if ( ! defined( 'WPINC' ) ) {
	die; // Prevent direct access
}

?>
<a href="/">tesdt</a>
<section class="bg-gray">
    <div class="max-w-[1170px] px-[15px] tablet:px-6 desktop:px-[15px] flex flex-wrap flex-col desktop:flex-row mx-auto justify-between py-[6px]">
        <div class="w-full desktop:w-3/5 desktop:pr-[15px] blog-article-wrapper">
            <article class="blog-post-article">
                <div class="blog-article-header">
                    <h1></h1>
					<?php if ( ! empty( $categories_html ) ): ?>
                        <div class="blog-article-categories"><?= $categories_html ?></div>
					<?php endif; ?>
                    <p class="date"></p>
                    <div class="blog-article-info">
						<?php if ( ! empty( $author_html ) ): ?>
                            <div class="blog-article-position"><?= $author_html ?></div>
						<?php endif; ?>
                        <div class="blog-article-follows">
                            <a href="#" aria-label="">
                                <svg focusable="false" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                     viewBox="0 0 32 32">
                                    <path fill="#22c8ff"
                                          d="M6.227 12.61h4.19v13.48h-4.19zm2.095-6.7a2.43 2.43 0 0 1 0 4.86c-1.344 0-2.428-1.09-2.428-2.43s1.084-2.43 2.428-2.43m4.72 6.7h4.02v1.84h.058c.56-1.058 1.927-2.176 3.965-2.176 4.238 0 5.02 2.792 5.02 6.42v7.395h-4.183v-6.56c0-1.564-.03-3.574-2.178-3.574-2.18 0-2.514 1.7-2.514 3.46v6.668h-4.187z"></path>
                                </svg>
                            </a>
                            <a href="#" aria-label="">
                                <svg focusable="false" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                     viewBox="0 0 32 32">
                                    <path fill="#22c8ff"
                                          d="M28 16c0-6.627-5.373-12-12-12S4 9.373 4 16c0 5.628 3.875 10.35 9.101 11.647v-7.98h-2.474V16H13.1v-1.58c0-4.085 1.849-5.978 5.859-5.978.76 0 2.072.15 2.608.298v3.325c-.283-.03-.775-.045-1.386-.045-1.967 0-2.728.745-2.728 2.683V16h3.92l-.673 3.667h-3.247v8.245C23.395 27.195 28 22.135 28 16"></path>
                                </svg>
                            </a>
                            <a href="#" aria-label="">
                                <svg focusable="false" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                     viewBox="0 0 32 32">
                                    <path fill="#22c8ff"
                                          d="M21.751 7h3.067l-6.7 7.658L26 25.078h-6.172l-4.833-6.32-5.531 6.32h-3.07l7.167-8.19L6 7h6.328l4.37 5.777L21.75 7Zm-1.076 16.242h1.7L11.404 8.74H9.58l11.094 14.503Z"></path>
                                </svg>
                            </a>
                        </div>
                    </div>
                    <figure class="blog-article-img"></figure>
                </div>
                <InnerBlocks
                        allowedBlocks="<?= esc_attr( wp_json_encode( $allowed_blocks ) ) ?>"
                        class="blog-article-content"
                        templateLock="false"
                ></InnerBlocks>
            </article>
        </div>
        <aside class="w-full desktop:w-2/5 desktop:pl-[15px]">
			<?php if ( ! empty( $related_posts_array ) ): ?>
				<?php foreach ( $related_posts_array as $post ): ?>
                    <article class="blog-article-card">
                        <a href="<?= esc_url( $post['link'] ) ?>" class="blog-article-img">
							<?php if ( ! empty( $post['image'] ) ): ?>
								<?= CommonUtils::get_img_tag( $post['image'] ) ?>
							<?php endif; ?>
                        </a>
                        <div>
                            <div class="blog-article-content">
                                <a href="<?= esc_url( $post['link'] ) ?>"><h2><?= esc_html( $post['title'] ) ?></h2></a>
								<?php if ( ! empty( $post['categories'] ) ): ?>
                                    <div class="blog-article-categories">
										<?= BlogArticleUtils::get_categories_html( $post['categories'] ) ?>
                                    </div>
								<?php endif; ?>
								<?php if ( ! empty( $post['date'] ) ): ?>
                                    <p class="date"><?= esc_html( $post['date'] ) ?></p>
								<?php endif; ?>
								<?php if ( ! empty( $post['author'] ) ): ?>
                                    <div class="blog-article-position">
										<?= BlogArticleUtils::get_author_html( $post['author'] ) ?>
                                    </div>
								<?php endif; ?>
                            </div>
                        </div>
                    </article>
				<?php endforeach; ?>
			<?php endif; ?>
        </aside>
    </div>
</section>