import {select, subscribe} from '@wordpress/data';

/**
 * Sync h1 with post title
 * @param {string} h1Elem DOM element selector
 */
export default function syncH1WithPostTitle(h1Elem) {
    const updateH1 = () => {
        const postTitle = select('core/editor').getEditedPostAttribute('title');
        if (h1Elem && postTitle) {
            h1Elem.textContent = postTitle;
        }
    };

    updateH1();
    subscribe(updateH1);
}