import {select, subscribe} from '@wordpress/data';

/**
 * Format date string
 * @param {string} dateStr ISO date
 * @returns {string} Human date like April 11th, 2025
 */
function formatDate(dateStr) {
    if (!dateStr) return '';
    const date = new Date(dateStr);
    const day = date.getDate();
    const month = date.toLocaleString('en-US', { month: 'long' });
    const year = date.getFullYear();

    // Add ordinal suffix
    let suffix = 'th';
    if (day % 10 === 1 && day !== 11) suffix = 'st';
    else if (day % 10 === 2 && day !== 12) suffix = 'nd';
    else if (day % 10 === 3 && day !== 13) suffix = 'rd';

    return `${month} ${day}${suffix}, ${year}`;
}

/**
 * Sync date
 * @param {string} dateElem DOM element selector
 */
export default function syncDate(dateElem) {
    const updateDate = () => {
        const postDate = select('core/editor').getEditedPostAttribute('date');
        if (dateElem && postDate) {
            dateElem.textContent = formatDate(postDate);
        }
    };

    updateDate();
    subscribe(updateDate);
}