<?php
use Headless\Utils\CommonUtils;

$id                 = get_field('block_id');
$header_icon        = get_field('header_icon');
$block_title        = get_field('title');
$first_column_data  = get_field('1st_column_data');
$second_column_data = get_field('2nd_column_image');
$third_column_data  = get_field('3rd_column_data');
$block_link         = get_field('button');

?>

<section class="about-standard" <?php if ($id) echo "id='{$id}'"; ?>>
    <div class="container">

        <?php if(!empty($block_title)): ?>
            <div class="section-header d-flex">
                <?= CommonUtils::render_image_acf($header_icon, [ 'width' => 24, 'height' => 24, 'alt' => 'about standard icon' ]); ?>
                <?=$block_title?>
            </div>
        <?php endif; ?>

        <div class="about-standard__content d-grid">

            <div class="about-standard__first" >
                <?php if(!empty($first_column_data)): ?>
                    <div class="about-standard__card d-flex flex-column">

                        <?php 
                            if(isset($first_column_data['icon'])){
                                echo CommonUtils::render_image_acf($first_column_data['icon'], [ 'width' => 25, 'height' => 25, 'alt' => 'Card icon', 'class' => 'about-standard__card__icon' ]);
                            }
                        ?>

                        <?php if(isset($first_column_data['title'])): ?>
                            <p class="about-standard__card__title"><?=$first_column_data['title']?></p>
                        <?php endif; ?>
                        
                        <?php if(isset($first_column_data['text'])): ?>
                            <p class="about-standard__card__text"><?=$first_column_data['text']?></p>
                        <?php endif; ?>

                    </div>
                <?php endif; ?>

                <?php
                    if(isset($first_column_data['image'])){
                        echo CommonUtils::render_image_acf($first_column_data['image'], [ 'width' => 343, 'height' => 250, 'alt' => 'Decor image' ]);
                    }
                ?>
            </div>

            <div class="about-standard__second">
                <?php
                    if(!empty($second_column_data)){
                        echo CommonUtils::render_image_acf($second_column_data, [ 'width' => 343, 'height' => 250, 'alt' => 'Decor image' ]);
                    }
                ?>
            </div>

            <div class="about-standard__third">

                <?php if(!empty($third_column_data)): ?>
                    <div class="about-standard__card d-flex flex-column justify-content-end">

                        <?php 
                            if(isset($third_column_data['icon'])){
                                echo CommonUtils::render_image_acf($third_column_data['icon'], [ 'width' => 25, 'height' => 25, 'alt' => 'Card icon', 'class' => 'about-standard__card__icon' ]);
                            }
                        ?>

                        <?php if(isset($third_column_data['title'])): ?>
                            <p class="about-standard__card__title"><?=$third_column_data['title']?></p>
                        <?php endif; ?>
                        
                        <?php if(isset($third_column_data['text'])): ?>
                            <p class="about-standard__card__text"><?=$third_column_data['text']?></p>
                        <?php endif; ?>

                    </div>
                <?php endif; ?>

                <?php 
                    if (!empty($block_link)) {
                        $block_link['classes'] = ['btn'];
                        echo CommonUtils::render_link($block_link);
                    }
                ?>
            </div>


        </div>

    </div>
</section>
