<?php
/**
 * Template Name: Blog Archive
 */

get_header();

$blog_title     = get_field( 'blog_title', 	'option' ) ?: '';
$blog_subtitle  = get_field( 'blog_text', 	'option' ) ?: '';
$translations	= get_field( 'translations', 	'option')  ?: [];

if(!isset($translations['load_more']) || empty($translations['load_more'])) $translations['load_more'] = 'Load more';
if(!isset($translations['loading']) || empty($translations['loading'])) $translations['loading'] = 'Loading';
if(!isset($translations['no_posts_found']) || empty($translations['no_posts_found'])) $translations['no_posts_found'] = 'No posts found.';

$paged = max( 1, get_query_var( 'paged' ) ?: get_query_var( 'page' ) ?: 1 );

$posts_query = new WP_Query( [
	'post_type'           => 'post',
	'post_status'         => 'publish',
	'posts_per_page'      => 12,
	'paged'               => $paged,
	'ignore_sticky_posts' => true,
] );

?>

<section class="blog-archive">
	<div class="container">

		<div class="blog-archive__header d-grid">
			<h1 class="blog-archive__title"><?= esc_html( $blog_title ); ?></h1>
			<h2 class="blog-archive__subtitle align-self-center"><?= esc_html( $blog_subtitle ); ?></h2>
		</div>

		<div class="blog-archive__list d-grid js-blog-list">
			<?php if ( $posts_query->have_posts() ) : ?>
				<?php while ( $posts_query->have_posts() ) : $posts_query->the_post(); ?>
					<?php get_template_part( 'template-parts/blog-card' ); ?>
				<?php endwhile; ?>
			<?php else : ?>
				<p><?= $translations['no_posts_found'] ?></p>
			<?php endif; ?>
			<?php wp_reset_postdata(); ?>
		</div>

		<?php if ( $posts_query->max_num_pages > $paged ) :
			$load_more_config = [
				'ajaxUrl'     => admin_url( 'admin-ajax.php' ),
				'nonce'       => wp_create_nonce( 'headless_load_more_posts' ),
				'currentPage' => $paged,
				'maxPage'     => (int) $posts_query->max_num_pages,
				'queryVars'   => $posts_query->query_vars,
				'labels'      => [
					'more'    => $translations['load_more'],
					'loading' => $translations['loading'],
				],
			];
			?>
			<div class="blog-archive__loadmore d-flex">
				<button
					class="btn btn__no-arrow blog-archive__loadmore-btn js-blog-loadmore"
					type="button"
					data-loadmore='<?= esc_attr( wp_json_encode( $load_more_config ) ); ?>'
				>
					<?= esc_html( $translations['load_more'] ); ?>
				</button>
			</div>
		<?php endif; ?>

	</div>
</section>

<?php 
get_template_part('tmp/contact-from');
get_footer();