<?php

declare( strict_types=1 );

namespace Headless\Traits;

use Headless\Kernel\Core;
use RuntimeException;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Trait Loadable
 *
 * Provides a reusable method for modules to register themselves with Core
 * This trait simplifies the process of adding a module to the system by
 * encapsulating the registration logic
 */
trait Loadable {

	/**
	 * Registers the current class with Core
	 *
	 * This static method is called at the end of each module file to ensure
	 * it is added to the Core registry for later initialization
	 *
	 * @throws RuntimeException If Core class is not available
	 */
	public static function load(): void {
		if ( ! class_exists( Core::class ) ) {
			throw new RuntimeException( 'Core class is not available for module registration' );
		}
		Core::register_class( static::class );
	}
}