<?php

namespace Headless\Modules\Entities\Traits;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Trait Labels
 *
 * Provides full set of labels for custom post types
 */
trait Labels {

	/**
	 * Generate full set of labels for custom post types
	 *
	 * @param string $singular Singular label
	 * @param string|null $plural Plural label
	 *
	 * @return array Array of labels
	 */
	public static function post_type_labels( string $singular, ?string $plural = null ): array {
		$plural = $plural ?: $singular . 's';

		return [
			'name'                  => $plural,
			'singular_name'         => $singular,
			'add_new'               => __( 'Add New', 'headless' ),
			'add_new_item'          => sprintf( __( 'Add New %s', 'headless' ), $singular ),
			'edit_item'             => sprintf( __( 'Edit %s', 'headless' ), $singular ),
			'new_item'              => sprintf( __( 'New %s', 'headless' ), $singular ),
			'view_item'             => sprintf( __( 'View %s', 'headless' ), $singular ),
			'view_items'            => sprintf( __( 'View %s', 'headless' ), $plural ),
			'search_items'          => sprintf( __( 'Search %s', 'headless' ), $plural ),
			'not_found'             => sprintf( __( 'No %s found', 'headless' ), strtolower( $plural ) ),
			'not_found_in_trash'    => sprintf( __( 'No %s found in Trash', 'headless' ), strtolower( $plural ) ),
			'parent_item_colon'     => sprintf( __( 'Parent %s:', 'headless' ), $singular ),
			'all_items'             => sprintf( __( 'All %s', 'headless' ), $plural ),
			'archives'              => sprintf( __( '%s Archives', 'headless' ), $singular ),
			'attributes'            => sprintf( __( '%s Attributes', 'headless' ), $singular ),
			'insert_into_item'      => sprintf( __( 'Insert into %s', 'headless' ), strtolower( $singular ) ),
			'uploaded_to_this_item' => sprintf( __( 'Uploaded to this %s', 'headless' ), strtolower( $singular ) ),
			'featured_image'        => __( 'Featured image', 'headless' ),
			'set_featured_image'    => __( 'Set featured image', 'headless' ),
			'remove_featured_image' => __( 'Remove featured image', 'headless' ),
			'use_featured_image'    => __( 'Use as featured image', 'headless' ),
			'menu_name'             => $plural,
			'filter_items_list'     => sprintf( __( 'Filter %s list', 'headless' ), strtolower( $plural ) ),
			'items_list_navigation' => sprintf( __( '%s list navigation', 'headless' ), $plural ),
			'items_list'            => sprintf( __( '%s list', 'headless' ), $plural ),
		];
	}

	/**
	 * Generate a full set of labels for a taxonomy
	 *
	 * @param string $singular Singular label for the taxonomy
	 * @param string|null $plural Optional plural label for the taxonomy. Defaults to singular + 's'
	 *
	 * @return array Array of labels for the taxonomy
	 */
	public static function taxonomy_labels( string $singular, ?string $plural = null ): array {

		// Defaults to singular + 's'.
		$plural = $plural ?: $singular . 's';

		return [
			'name'                       => $plural,
			'singular_name'              => $singular,
			'search_items'               => sprintf( __( 'Search %s', 'headless' ), $plural ),
			'popular_items'              => sprintf( __( 'Popular %s', 'headless' ), $plural ),
			'all_items'                  => sprintf( __( 'All %s', 'headless' ), $plural ),
			'parent_item'                => sprintf( __( 'Parent %s', 'headless' ), $singular ),
			'parent_item_colon'          => sprintf( __( 'Parent %s:', 'headless' ), $singular ),
			'edit_item'                  => sprintf( __( 'Edit %s', 'headless' ), $singular ),
			'view_item'                  => sprintf( __( 'View %s', 'headless' ), $singular ),
			'update_item'                => sprintf( __( 'Update %s', 'headless' ), $singular ),
			'add_new_item'               => sprintf( __( 'Add New %s', 'headless' ), $singular ),
			'new_item_name'              => sprintf( __( 'New %s Name', 'headless' ), $singular ),
			'separate_items_with_commas' => sprintf( __( 'Separate %s with commas', 'headless' ), strtolower( $plural ) ),
			'add_or_remove_items'        => sprintf( __( 'Add or remove %s', 'headless' ), strtolower( $plural ) ),
			'choose_from_most_used'      => sprintf( __( 'Choose from the most used %s', 'headless' ), strtolower( $plural ) ),
			'not_found'                  => sprintf( __( 'No %s found', 'headless' ), strtolower( $plural ) ),
			'no_terms'                   => sprintf( __( 'No %s', 'headless' ), strtolower( $plural ) ),
			'items_list_navigation'      => sprintf( __( '%s list navigation', 'headless' ), $plural ),
			'items_list'                 => sprintf( __( '%s list', 'headless' ), $plural ),
			'menu_name'                  => $plural,
		];
	}
}
