<?php
declare( strict_types=1 );

namespace Headless\Modules\Entities\Defaults;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class DefaultTaxonomies
 *
 * Modifies default taxonomies
 */
class DefaultTaxonomies {

	/**
	 * Modify default taxonomies
	 *
	 * @return void
	 */
	public static function modify(): void {

		// When registering a taxonomy, modify the arguments
		add_filter( 'register_taxonomy_args', function ( array $args, string $taxonomy ): array {
			// Hide post tags and categories from the UI
			// if ( in_array( $taxonomy, [ 'post_tag', 'category' ] ) ) {
			// 	$args['public']            = false;
			// 	$args['show_ui']           = false;
			// 	$args['show_in_rest']      = false;
			// 	$args['show_admin_column'] = false;
			// 	$args['show_in_graphql']   = false;
			// }

			// Return the modified arguments
			return $args;
		}, 10, 2 );
	}
}
