<?php

declare( strict_types=1 );

namespace Headless\Modules\Blocks;

use Headless\Interfaces\Registrable;
use Headless\Traits\Loadable;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class BlocksManager
 *
 * Handles the management of Gutenberg blocks in the WordPress theme
 */

class BlocksManager implements Registrable {

	use Loadable;

	/**
	 * Register the assets by hooking into WordPress
	 *
	 * @return void
	 */
	
	public function register(): void {

		// Register blocks
		add_action( 'init', [ BlockRegister::class, 'register_blocks' ] );
		
		// Filter allowed blocks
		add_filter( 'allowed_block_types_all', [ BlockRestrict::class, 'allowed_blocks' ], 10, 2 );

		// Enqueue single post assets for blog article block
		add_action( 'wp_enqueue_scripts', [ BlockRestrict::class, 'enqueue_single_assets' ] );

		// Add dependencies to blocks
		add_action( 'init', [ BlockDependencies::class, 'add_dependencies' ] );

	}

}

BlocksManager::load();
