<?php

declare( strict_types=1 );

namespace Headless\Modules\BlockTermsSync\Interfaces;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Interface BlockTermsSyncHandler
 *
 * Should be implemented by all modules that handle the synchronization of terms in a Gutenberg block
 */
interface BlockTermsSyncHandler {

	/**
	 * Synchronizes the terms in a Gutenberg block
	 *
	 * @param int $post_id Post ID
	 * @param array $block_data Block data
	 *
	 * @return void
	 */
	public function sync( int $post_id, array $block_data ): void;
}
