<?php

declare( strict_types=1 );

namespace Headless\Modules\BlockTermsSync\Blocks;

use Headless\Modules\BlockTermsSync\Interfaces\BlockTermsSyncHandler;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class BlogArticle
 *
 * This class handles synchronization of terms for the "Blog Article" block
 */

class BlogArticle implements BlockTermsSyncHandler {

	/**
	 * Synchronize the terms for the Blog Article block
	 *
	 * @param int    $post_id    The post ID
	 * @param array  $block_data The block data
	 *
	 * @return void
	 */
	public function sync( int $post_id, array $block_data ): void {

		// Get the categories from the block data
		$categories = array_filter( array_map( 'intval', $block_data['blog_categories'] ?? [] ) );

		// If we have categories, set them
		if ( ! empty( $categories ) ) {
			wp_set_object_terms( $post_id, $categories, 'blog_category' );
		}

		// Get the author from the block data
		$author = $block_data['blog_author'] ?? null;

		// If we have an author, set it
		if ( ! empty( $author ) ) {

			wp_set_object_terms( $post_id, (int) $author, 'blog_author' );
		}
	}
}
