<?php
/**
 * The template for displaying 404 page
 *
 * @package Genesis Block Theme
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Headless\Utils\CommonUtils;

get_header(); 

$texts_404 		= get_field('texts_404', 'option');
$link_from_404 	= get_field('link_from_404', 'option');

if(!isset($texts_404['title']) || empty($texts_404['title'])) $texts_404['title'] = '404';
if(!isset($texts_404['text']) || empty($texts_404['text'])) $texts_404['text'] = 'Page is not found';

?>

<main id="main" class="not-found">
	<div class="container">
		<h1><?=$texts_404['title']?></h1>
		<p><?=$texts_404['text']?></p>
		<?php if (!empty($link_from_404)) : $link_from_404['classes'] = ['btn']; ?>
			<?= CommonUtils::render_link( $link_from_404 ) ?>
		<?php endif; ?>
	</div>
</main><!-- #main -->

<?php get_footer(); ?>