<?php
/**
 * Genesis Blocks Team Members section for Slate Collection.
 *
 * @package genesis-blocks
 */

return [
	'type'       => 'section',
	'key'        => 'gb_slate_section_team_members',
	'collection' => [
		'slug'                   => 'slate',
		'label'                  => esc_html__( 'Slate', 'genesis-blocks' ),
		'allowThemeColorPalette' => false,
	],
	'content'    => "<!-- wp:genesis-blocks/gb-columns {\"columns\":1,\"layout\":\"one-column\",\"align\":\"full\",\"paddingTop\":6,\"paddingRight\":1,\"paddingBottom\":6,\"paddingLeft\":1,\"paddingUnit\":\"em\",\"customTextColor\":\"#1f1f1f\",\"customBackgroundColor\":\"#ffffff\",\"columnMaxWidth\":1200,\"className\":\"gb-slate-section-team-members gb-layout-team-1 gb-slate-team \"} -->
<div class=\"wp-block-genesis-blocks-gb-columns gb-slate-section-team-members gb-layout-team-1 gb-slate-team gb-layout-columns-1 one-column gb-has-custom-background-color gb-has-custom-text-color gb-columns-center alignfull\" style=\"padding-top:6em;padding-right:1em;padding-bottom:6em;padding-left:1em;background-color:#ffffff;color:#1f1f1f\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\" style=\"max-width:1200px\"><!-- wp:genesis-blocks/gb-column -->
<div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-container {\"containerMarginBottom\":5,\"containerMaxWidth\":840} -->
<div style=\"margin-bottom:5%\" class=\"wp-block-genesis-blocks-gb-container gb-block-container\"><div class=\"gb-container-inside\"><div class=\"gb-container-content\" style=\"max-width:840px\"><!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"color\":{\"text\":\"#1f1f1f\"},\"typography\":{\"fontSize\":40}}} -->
<h2 class=\"has-text-align-center has-text-color\" style=\"color:#1f1f1f;font-size:40px\">Meet our amazing team.</h2>
<!-- /wp:heading -->

<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#1f1f1f\"}}} -->
<p class=\"has-text-align-center has-text-color\" style=\"color:#1f1f1f\">We're a talented group of creative individuals interested in art, cinematography, design, music, and all niches in between. Get to know us and what we can do for you!</p>
<!-- /wp:paragraph --></div></div></div>
<!-- /wp:genesis-blocks/gb-container -->

<!-- wp:genesis-blocks/gb-columns {\"columns\":3,\"layout\":\"gb-3-col-equal\"} -->
<div class=\"wp-block-genesis-blocks-gb-columns gb-layout-columns-3 gb-3-col-equal\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\"><!-- wp:genesis-blocks/gb-column -->
<div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-profile-box {\"profileImgID\":10230,\"profileBackgroundColor\":\"#ffffff\",\"profileTextColor\":\"#1f1f1f\"} -->
<div style=\"background-color:#ffffff;color:#1f1f1f\" class=\"wp-block-genesis-blocks-gb-profile-box square gb-has-avatar gb-font-size-18 gb-block-profile gb-profile-columns\"><div class=\"gb-profile-column gb-profile-avatar-wrap\"><div class=\"gb-profile-image-wrap\"><figure class=\"gb-profile-image-square\"><img class=\"gb-profile-avatar wp-image-10230\" src=\"https://demo.studiopress.com/page-builder/person-m-1.jpg\" alt=\"team member avatar\"/></figure></div></div><div class=\"gb-profile-column gb-profile-content-wrap\"><h2 class=\"gb-profile-name\" style=\"color:#1f1f1f\">Kyle Zion</h2><p class=\"gb-profile-title\" style=\"color:#1f1f1f\">Screenprinter</p><div class=\"gb-profile-text\"><p>Add biography text for your team member here. You can also remove this text if you'd rather just have a name and title.</p></div><ul class=\"gb-social-links\"></ul></div></div>
<!-- /wp:genesis-blocks/gb-profile-box --></div></div>
<!-- /wp:genesis-blocks/gb-column -->

<!-- wp:genesis-blocks/gb-column -->
<div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-profile-box {\"profileImgID\":10211,\"profileBackgroundColor\":\"#ffffff\",\"profileTextColor\":\"#1f1f1f\"} -->
<div style=\"background-color:#ffffff;color:#1f1f1f\" class=\"wp-block-genesis-blocks-gb-profile-box square gb-has-avatar gb-font-size-18 gb-block-profile gb-profile-columns\"><div class=\"gb-profile-column gb-profile-avatar-wrap\"><div class=\"gb-profile-image-wrap\"><figure class=\"gb-profile-image-square\"><img class=\"gb-profile-avatar wp-image-10211\" src=\"https://demo.studiopress.com/page-builder/person-w-3.jpg\" alt=\"avatar placeholder\"/></figure></div></div><div class=\"gb-profile-column gb-profile-content-wrap\"><h2 class=\"gb-profile-name\" style=\"color:#1f1f1f\">Fran Acadia</h2><p class=\"gb-profile-title\" style=\"color:#1f1f1f\">People Engineer</p><div class=\"gb-profile-text\"><p>Add biography text for your team member here. You can also remove this text if you'd rather just have a name and title.</p></div><ul class=\"gb-social-links\"></ul></div></div>
<!-- /wp:genesis-blocks/gb-profile-box --></div></div>
<!-- /wp:genesis-blocks/gb-column -->

<!-- wp:genesis-blocks/gb-column -->
<div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-profile-box {\"profileImgID\":10225,\"profileBackgroundColor\":\"#ffffff\",\"profileTextColor\":\"#1f1f1f\"} -->
<div style=\"background-color:#ffffff;color:#1f1f1f\" class=\"wp-block-genesis-blocks-gb-profile-box square gb-has-avatar gb-font-size-18 gb-block-profile gb-profile-columns\"><div class=\"gb-profile-column gb-profile-avatar-wrap\"><div class=\"gb-profile-image-wrap\"><figure class=\"gb-profile-image-square\"><img class=\"gb-profile-avatar wp-image-10225\" src=\"https://demo.studiopress.com/page-builder/person-m-3.jpg\" alt=\"team member avatar\"/></figure></div></div><div class=\"gb-profile-column gb-profile-content-wrap\"><h2 class=\"gb-profile-name\" style=\"color:#1f1f1f\">Giannis Teton</h2><p class=\"gb-profile-title\" style=\"color:#1f1f1f\">Office Manager</p><div class=\"gb-profile-text\"><p>Add biography text for your team member here. You can also remove this text if you'd rather just have a name and title.</p></div><ul class=\"gb-social-links\"></ul></div></div>
<!-- /wp:genesis-blocks/gb-profile-box --></div></div>
<!-- /wp:genesis-blocks/gb-column --></div></div>
<!-- /wp:genesis-blocks/gb-columns --></div></div>
<!-- /wp:genesis-blocks/gb-column --></div></div>
<!-- /wp:genesis-blocks/gb-columns -->",
	'name'       => esc_html__( 'Slate Team Members', 'genesis-blocks' ),
	'category'   => [
		esc_html__( 'services', 'genesis-blocks' ),
		esc_html__( 'business', 'genesis-blocks' ),
		esc_html__( 'team', 'genesis-blocks' ),
	],
	'keywords'   => [
		esc_html__( 'business', 'genesis-blocks' ),
		esc_html__( 'product', 'genesis-blocks' ),
		esc_html__( 'landing', 'genesis-blocks' ),
		esc_html__( 'button', 'genesis-blocks' ),
		esc_html__( 'slate', 'genesis-blocks' ),
		esc_html__( 'slate team members', 'genesis-blocks' ),
	],
	'image'      => 'https://demo.studiopress.com/page-builder/slate/gb_slate_section_team_members.jpg',
];
